/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.treasure.loot;

import com.google.gson.JsonObject;
import greymerk.roguelike.treasure.loot.PotionForm;
import greymerk.roguelike.util.IWeighted;
import greymerk.roguelike.util.WeightedChoice;
import java.util.Random;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;

public enum Potion {
    HEALING,
    HARM,
    REGEN,
    POISON,
    STRENGTH,
    WEAKNESS,
    SLOWNESS,
    SWIFTNESS,
    FIRERESIST;


    public static ItemStack getRandom(Random rand) {
        Potion type = Potion.values()[rand.nextInt(Potion.values().length)];
        return Potion.getSpecific(rand, type);
    }

    public static ItemStack getSpecific(Random rand, Potion effect) {
        return Potion.getSpecific(PotionForm.REGULAR, effect, rand.nextBoolean(), rand.nextBoolean());
    }

    public static ItemStack getSpecific(Random rand, PotionForm type, Potion effect) {
        return Potion.getSpecific(type, effect, rand.nextBoolean(), rand.nextBoolean());
    }

    public static IWeighted<ItemStack> get(JsonObject data, int weight) throws Exception {
        if (!data.has("name")) {
            throw new Exception("Potion missing name field");
        }
        String nameString = data.get("name").getAsString();
        PotionType type = PotionType.func_185168_a((String)nameString);
        ItemStack item = !data.has("form") ? new ItemStack((Item)Items.field_151068_bn) : (data.get("form").getAsString().toLowerCase().equals("splash") ? new ItemStack((Item)Items.field_185155_bH) : (data.get("form").getAsString().toLowerCase().equals("lingering") ? new ItemStack((Item)Items.field_185156_bI) : new ItemStack((Item)Items.field_151068_bn)));
        return new WeightedChoice<ItemStack>(PotionUtils.func_185188_a((ItemStack)item, (PotionType)type), weight);
    }

    public static ItemStack getSpecific(PotionForm type, Potion effect, boolean upgrade, boolean extend) {
        ItemStack potion;
        switch (type) {
            case REGULAR: {
                potion = new ItemStack((Item)Items.field_151068_bn);
                break;
            }
            case SPLASH: {
                potion = new ItemStack((Item)Items.field_185155_bH);
                break;
            }
            case LINGERING: {
                potion = new ItemStack((Item)Items.field_185156_bI);
                break;
            }
            default: {
                potion = new ItemStack((Item)Items.field_151068_bn);
            }
        }
        PotionType data = Potion.getEffect(effect, upgrade, extend);
        return PotionUtils.func_185188_a((ItemStack)potion, (PotionType)data);
    }

    public static PotionType getEffect(Potion effect, boolean upgrade, boolean extend) {
        if (effect == null) {
            return PotionTypes.field_185233_e;
        }
        switch (effect) {
            case HEALING: {
                return upgrade ? PotionTypes.field_185251_w : PotionTypes.field_185250_v;
            }
            case HARM: {
                return upgrade ? PotionTypes.field_185253_y : PotionTypes.field_185252_x;
            }
            case REGEN: {
                if (extend) {
                    return PotionTypes.field_185221_D;
                }
                return upgrade ? PotionTypes.field_185222_E : PotionTypes.field_185220_C;
            }
            case POISON: {
                if (extend) {
                    return PotionTypes.field_185218_A;
                }
                return upgrade ? PotionTypes.field_185219_B : PotionTypes.field_185254_z;
            }
            case STRENGTH: {
                if (extend) {
                    return PotionTypes.field_185224_G;
                }
                return upgrade ? PotionTypes.field_185225_H : PotionTypes.field_185223_F;
            }
            case WEAKNESS: {
                if (extend) {
                    return PotionTypes.field_185227_J;
                }
                return PotionTypes.field_185226_I;
            }
            case SLOWNESS: {
                if (extend) {
                    return PotionTypes.field_185247_s;
                }
                return PotionTypes.field_185246_r;
            }
            case SWIFTNESS: {
                if (extend) {
                    return PotionTypes.field_185244_p;
                }
                return upgrade ? PotionTypes.field_185245_q : PotionTypes.field_185243_o;
            }
            case FIRERESIST: {
                if (extend) {
                    return PotionTypes.field_185242_n;
                }
                return PotionTypes.field_185241_m;
            }
        }
        return PotionTypes.field_185233_e;
    }
}

