/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.worldgen;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import greymerk.roguelike.worldgen.BlockBase;
import greymerk.roguelike.worldgen.BlockProvider;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.IBlockFactory;
import greymerk.roguelike.worldgen.WorldEditor;
import java.util.ArrayList;
import java.util.Random;

public class BlockCheckers
extends BlockBase {
    private IBlockFactory fillOne;
    private IBlockFactory fillTwo;
    private Coord offset;

    public BlockCheckers(IBlockFactory fillOne, IBlockFactory fillTwo, Coord offset) {
        this.fillOne = fillOne;
        this.fillTwo = fillTwo;
        this.offset = new Coord(offset);
    }

    public BlockCheckers(IBlockFactory fillOne, IBlockFactory fillTwo) {
        this(fillOne, fillTwo, new Coord(0, 0, 0));
    }

    public BlockCheckers(JsonElement json) throws Exception {
        JsonArray arr = (JsonArray)json;
        ArrayList<IBlockFactory> blocks = new ArrayList<IBlockFactory>();
        for (JsonElement jsonElement : arr) {
            if (jsonElement.isJsonNull()) continue;
            blocks.add(BlockProvider.create(jsonElement.getAsJsonObject()));
        }
        this.fillOne = (IBlockFactory)blocks.get(0);
        this.fillTwo = (IBlockFactory)blocks.get(1);
    }

    @Override
    public boolean set(WorldEditor editor, Random rand, Coord origin, boolean fillAir, boolean replaceSolid) {
        int x = origin.getX() - this.offset.getX();
        int y = origin.getY() - this.offset.getY();
        int z = origin.getZ() - this.offset.getY();
        if (x % 2 == 0) {
            if (z % 2 == 0) {
                if (y % 2 == 0) {
                    return this.fillOne.set(editor, rand, new Coord(origin), fillAir, replaceSolid);
                }
                return this.fillTwo.set(editor, rand, new Coord(origin), fillAir, replaceSolid);
            }
            if (y % 2 == 0) {
                return this.fillTwo.set(editor, rand, new Coord(origin), fillAir, replaceSolid);
            }
            return this.fillOne.set(editor, rand, new Coord(origin), fillAir, replaceSolid);
        }
        if (z % 2 == 0) {
            if (y % 2 == 0) {
                return this.fillTwo.set(editor, rand, new Coord(origin), fillAir, replaceSolid);
            }
            return this.fillOne.set(editor, rand, new Coord(origin), fillAir, replaceSolid);
        }
        if (y % 2 == 0) {
            return this.fillOne.set(editor, rand, new Coord(origin), fillAir, replaceSolid);
        }
        return this.fillTwo.set(editor, rand, new Coord(origin), fillAir, replaceSolid);
    }
}

