/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.worldgen;

import greymerk.roguelike.worldgen.Cardinal;
import java.util.Objects;
import net.minecraft.util.math.BlockPos;

public class Coord {
    private int x;
    private int y;
    private int z;

    public Coord(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Coord(Coord toClone) {
        this.x = toClone.x;
        this.y = toClone.y;
        this.z = toClone.z;
    }

    public Coord(BlockPos bp) {
        this.x = bp.func_177958_n();
        this.y = bp.func_177956_o();
        this.z = bp.func_177952_p();
    }

    public static void correct(Coord one, Coord two) {
        int temp;
        if (two.x < one.x) {
            temp = two.x;
            two.x = one.x;
            one.x = temp;
        }
        if (two.y < one.y) {
            temp = two.y;
            two.y = one.y;
            one.y = temp;
        }
        if (two.z < one.z) {
            temp = two.z;
            two.z = one.z;
            one.z = temp;
        }
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public Coord copy() {
        return new Coord(this);
    }

    public Coord add(Cardinal dir) {
        return new Coord(this).translate(dir, 1);
    }

    public Coord translate(Cardinal dir, int amount) {
        switch (dir) {
            case UP: {
                return this.up(amount);
            }
            case DOWN: {
                return this.down(amount);
            }
            case NORTH: {
                return this.north(amount);
            }
            case EAST: {
                return this.east(amount);
            }
            case SOUTH: {
                return this.south(amount);
            }
            case WEST: {
                return this.west(amount);
            }
        }
        return this;
    }

    public Coord translate(int x, int y, int z) {
        this.x += x;
        this.y += y;
        this.z += z;
        return this;
    }

    public Coord translate(Coord other) {
        return this.translate(other.x, other.y, other.z);
    }

    public Coord translate(Cardinal dir) {
        this.translate(dir, 1);
        return this;
    }

    public Coord up(int amount) {
        this.y += amount;
        return this;
    }

    public Coord down(int amount) {
        this.y -= amount;
        return this;
    }

    public Coord north(int amount) {
        this.z -= amount;
        return this;
    }

    public Coord east(int amount) {
        this.x += amount;
        return this;
    }

    public Coord south(int amount) {
        this.z += amount;
        return this;
    }

    public Coord west(int amount) {
        this.x -= amount;
        return this;
    }

    public Coord add(Coord other) {
        return new Coord(this).translate(other);
    }

    public Coord add(int x, int y, int z) {
        return new Coord(this).translate(x, y, z);
    }

    public double distance(Coord other) {
        double side1 = Math.abs(this.getX() - other.getX());
        double side2 = Math.abs(this.getZ() - other.getZ());
        return Math.sqrt(side1 * side1 + side2 * side2);
    }

    public Cardinal dirTo(Coord other) {
        int xdiff = other.x - this.x;
        int ydiff = other.y - this.y;
        int zdiff = other.z - this.z;
        if (Math.abs(ydiff) > Math.abs(xdiff) && Math.abs(ydiff) > Math.abs(zdiff)) {
            return Cardinal.UP;
        }
        if (Math.abs(xdiff) < Math.abs(zdiff)) {
            if (zdiff < 0) {
                return Cardinal.NORTH;
            }
            return Cardinal.SOUTH;
        }
        if (xdiff < 0) {
            return Cardinal.WEST;
        }
        return Cardinal.EAST;
    }

    public int hashCode() {
        return Objects.hash(this.x, this.y, this.z);
    }

    public String toString() {
        String toReturn = "";
        toReturn = toReturn + "x: " + this.x + " ";
        toReturn = toReturn + "y: " + this.y + " ";
        toReturn = toReturn + "z: " + this.z;
        return toReturn;
    }

    public boolean equals(Object o) {
        Coord other = (Coord)o;
        if (this.x != other.x) {
            return false;
        }
        if (this.y != other.y) {
            return false;
        }
        return this.z == other.z;
    }

    public BlockPos getBlockPos() {
        return new BlockPos(this.x, this.y, this.z);
    }
}

