/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.worldgen;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import greymerk.roguelike.worldgen.BlockBase;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.WorldEditor;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class MetaBlock
extends BlockBase
implements IBlockState {
    private IBlockState state;
    private int flag;

    public MetaBlock(Block block) {
        this.setState(block.func_176223_P());
        this.flag = 2;
    }

    public MetaBlock(MetaBlock block) {
        this.setState(block);
        this.flag = 2;
    }

    public MetaBlock(IBlockState state) {
        this.setState(state);
        this.flag = 2;
    }

    public MetaBlock(Block block, IProperty<?> ... properties) {
        BlockStateContainer s = new BlockStateContainer(block, properties);
        this.setState(s.func_177621_b());
    }

    public MetaBlock(JsonElement e) throws Exception {
        JsonObject json = (JsonObject)e;
        String name = json.get("name").getAsString();
        ResourceLocation location = new ResourceLocation(name);
        if (!Block.field_149771_c.func_148741_d((Object)location)) {
            throw new Exception("No such block: " + name);
        }
        Block block = (Block)Block.field_149771_c.func_82594_a((Object)location);
        int meta = json.has("meta") ? json.get("meta").getAsInt() : 0;
        this.setState(block.func_176203_a(meta));
        this.flag = json.has("flag") ? json.get("flag").getAsInt() : 2;
    }

    public boolean set(WorldEditor editor, Coord pos) {
        return editor.setBlock(pos, this, true, true);
    }

    @Override
    public boolean set(WorldEditor editor, Random rand, Coord pos, boolean fillAir, boolean replaceSolid) {
        return editor.setBlock(pos, this, fillAir, replaceSolid);
    }

    public <T extends Comparable<T>> T func_177229_b(IProperty<T> property) {
        return (T)this.state.func_177229_b(property);
    }

    public <T extends Comparable<T>, V extends T> IBlockState func_177226_a(IProperty<T> property, V value) {
        this.state = this.state.func_177226_a(property, value);
        return this.state;
    }

    public <T extends Comparable<T>> IBlockState func_177231_a(IProperty<T> property) {
        return this.state.func_177231_a(property);
    }

    public IBlockState getState() {
        if (this.state instanceof MetaBlock) {
            return ((MetaBlock)this.state).getState();
        }
        return this.state;
    }

    public void setState(IBlockState state) {
        if (state instanceof MetaBlock) {
            this.state = ((MetaBlock)state).getState();
            return;
        }
        this.state = state;
    }

    public Block func_177230_c() {
        return this.getState().func_177230_c();
    }

    public int getFlag() {
        return this.flag;
    }

    public String toString() {
        return this.state.func_177230_c().func_149739_a();
    }

    public Material func_185904_a() {
        return this.state.func_185904_a();
    }

    public boolean func_185913_b() {
        return this.state.func_185913_b();
    }

    public boolean func_185916_f() {
        return this.state.func_185916_f();
    }

    public IBlockState func_185907_a(Rotation rot) {
        return this.state.func_185907_a(rot);
    }

    public IBlockState func_185902_a(Mirror mirrorIn) {
        return this.state.func_185902_a(mirrorIn);
    }

    public boolean func_185917_h() {
        return this.state.func_185917_h();
    }

    public EnumBlockRenderType func_185901_i() {
        return this.state.func_185901_i();
    }

    public boolean func_185898_k() {
        return this.state.func_185898_k();
    }

    public boolean func_185915_l() {
        return this.state.func_185915_l();
    }

    public boolean func_185897_m() {
        return this.state.func_185897_m();
    }

    public int func_185911_a(IBlockAccess p_185911_1_, BlockPos p_185911_2_, EnumFacing p_185911_3_) {
        return this.state.func_185911_a(p_185911_1_, p_185911_2_, p_185911_3_);
    }

    public boolean func_185912_n() {
        return this.state.func_185912_n();
    }

    public int func_185888_a(World p_185888_1_, BlockPos p_185888_2_) {
        return this.state.func_185888_a(p_185888_1_, p_185888_2_);
    }

    public float func_185887_b(World p_185887_1_, BlockPos p_185887_2_) {
        return this.state.func_185887_b(p_185887_1_, p_185887_2_);
    }

    public float func_185903_a(EntityPlayer p_185903_1_, World p_185903_2_, BlockPos p_185903_3_) {
        return this.state.func_185903_a(p_185903_1_, p_185903_2_, p_185903_3_);
    }

    public int func_185893_b(IBlockAccess p_185893_1_, BlockPos p_185893_2_, EnumFacing p_185893_3_) {
        return this.state.func_185893_b(p_185893_1_, p_185893_2_, p_185893_3_);
    }

    public EnumPushReaction func_185905_o() {
        return this.state.func_185905_o();
    }

    public IBlockState func_185899_b(IBlockAccess p_185899_1_, BlockPos p_185899_2_) {
        return this.state.func_185899_b(p_185899_1_, p_185899_2_);
    }

    public boolean func_185914_p() {
        return this.state.func_185914_p();
    }

    public AxisAlignedBB func_185918_c(World p_185890_1_, BlockPos p_185890_2_) {
        return this.state.func_185918_c(p_185890_1_, p_185890_2_);
    }

    public ImmutableMap<IProperty<?>, Comparable<?>> func_177228_b() {
        return this.state.func_177228_b();
    }

    public int getLightOpacity(IBlockAccess world, BlockPos pos) {
        return this.state.getLightOpacity(world, pos);
    }

    public int getLightValue(IBlockAccess world, BlockPos pos) {
        return this.state.getLightValue(world, pos);
    }

    public boolean func_185895_e() {
        return this.state.func_185895_e();
    }

    public int func_185889_a(IBlockAccess source, BlockPos pos) {
        return this.state.func_185889_a(source, pos);
    }

    public float func_185892_j() {
        return this.state.func_185892_j();
    }

    public boolean func_185894_c(IBlockAccess blockAccess, BlockPos pos, EnumFacing facing) {
        return this.state.func_185894_c(blockAccess, pos, facing);
    }

    public AxisAlignedBB func_185900_c(IBlockAccess blockAccess, BlockPos pos) {
        return this.state.func_185900_c(blockAccess, pos);
    }

    public RayTraceResult func_185910_a(World worldIn, BlockPos pos, Vec3d start, Vec3d end) {
        return this.state.func_185910_a(worldIn, pos, start, end);
    }

    public boolean doesSideBlockRendering(IBlockAccess world, BlockPos pos, EnumFacing side) {
        return this.state.doesSideBlockRendering(world, pos, side);
    }

    public boolean isSideSolid(IBlockAccess world, BlockPos pos, EnumFacing side) {
        return this.state.isSideSolid(world, pos, side);
    }

    public int func_185891_c() {
        return this.state.func_185891_c();
    }

    public boolean func_189547_a(World arg0, BlockPos arg1, int arg2, int arg3) {
        return this.state.func_189547_a(arg0, arg1, arg2, arg3);
    }

    public int func_185906_d() {
        return this.state.func_185906_d();
    }

    public void func_189546_a(World worldIn, BlockPos pos, Block blockIn, BlockPos p_189546_4_) {
        this.state.func_189546_a(worldIn, pos, blockIn, p_189546_4_);
    }

    public boolean func_189884_a(Entity entityIn) {
        return this.state.func_189884_a(entityIn);
    }

    public AxisAlignedBB func_185890_d(IBlockAccess worldIn, BlockPos pos) {
        return this.state.func_185890_d(worldIn, pos);
    }

    public boolean func_191057_i() {
        return this.state.func_191057_i();
    }

    public void func_185908_a(World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entityIn, boolean p_185908_6_) {
        this.state.func_185908_a(worldIn, pos, entityBox, collidingBoxes, entityIn, p_185908_6_);
    }

    public Vec3d func_191059_e(IBlockAccess access, BlockPos pos) {
        return this.state.func_191059_e(access, pos);
    }

    public boolean func_191058_s() {
        return this.state.func_191058_s();
    }

    public Collection<IProperty<?>> func_177227_a() {
        return this.state.func_177227_a();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof MetaBlock)) {
            return false;
        }
        MetaBlock otherBlock = (MetaBlock)other;
        return this.getState().equals(otherBlock.getState());
    }

    public MapColor func_185909_g(IBlockAccess p_185909_1_, BlockPos p_185909_2_) {
        return this.state.func_185909_g(p_185909_1_, p_185909_2_);
    }

    public boolean func_185896_q() {
        return this.state.func_185896_q();
    }

    public BlockFaceShape func_193401_d(IBlockAccess p_193401_1_, BlockPos p_193401_2_, EnumFacing p_193401_3_) {
        return this.state.func_193401_d(p_193401_1_, p_193401_2_, p_193401_3_);
    }

    public boolean doesSideBlockChestOpening(IBlockAccess world, BlockPos pos, EnumFacing side) {
        return this.state.doesSideBlockChestOpening(world, pos, side);
    }
}

