/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.worldgen;

import greymerk.roguelike.TreasureChestEditor;
import greymerk.roguelike.worldgen.Cardinal;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.IBlockFactory;
import greymerk.roguelike.worldgen.IPositionInfo;
import greymerk.roguelike.worldgen.IStair;
import greymerk.roguelike.worldgen.MetaBlock;
import greymerk.roguelike.worldgen.PositionInfo;
import greymerk.roguelike.worldgen.VanillaStructure;
import greymerk.roguelike.worldgen.blocks.BlockType;
import greymerk.roguelike.worldgen.shapes.RectSolid;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.gen.ChunkProviderServer;

public class WorldEditor {
    private static final List<Material> invalid = new ArrayList<Material>();
    private final World world;
    private final Map<Block, Integer> stats = new HashMap<Block, Integer>();
    public final TreasureChestEditor treasureChestEditor;
    private Random random;

    public WorldEditor(World world) {
        this.world = world;
        this.random = new Random(Objects.hash(this.getSeed()));
        this.treasureChestEditor = new TreasureChestEditor(this, this.random);
    }

    public boolean isNonSolidBlock(Coord coord) {
        Coord cursor = coord.add(Cardinal.DOWN);
        return !this.getBlock(cursor).func_185904_a().func_76220_a();
    }

    public Random getRandom() {
        return this.random;
    }

    private boolean setBlock(Coord pos, MetaBlock block, int flags, boolean fillAir, boolean replaceSolid) {
        boolean isAir;
        MetaBlock currentBlock = this.getBlock(pos);
        if (currentBlock.func_177230_c() == Blocks.field_150486_ae) {
            return false;
        }
        if (currentBlock.func_177230_c() == Blocks.field_150447_bR) {
            return false;
        }
        if (currentBlock.func_177230_c() == Blocks.field_150474_ac) {
            return false;
        }
        boolean bl = isAir = currentBlock.func_177230_c() == Blocks.field_150350_a;
        if (!fillAir && isAir) {
            return false;
        }
        if (!replaceSolid && !isAir) {
            return false;
        }
        try {
            this.world.func_180501_a(pos.getBlockPos(), block.getState(), flags);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        Block type = block.func_177230_c();
        this.stats.merge(type, 1, Integer::sum);
        return true;
    }

    public boolean setBlock(Coord pos, MetaBlock block, boolean fillAir, boolean replaceSolid) {
        return this.setBlock(pos, block, block.getFlag(), fillAir, replaceSolid);
    }

    public boolean isAirBlock(Coord pos) {
        return this.world.func_175623_d(pos.getBlockPos());
    }

    public long getSeed() {
        return this.world.func_72905_C();
    }

    public Random getSeededRandom(int a, int b, int c) {
        return this.world.func_72843_D(a, b, c);
    }

    public void spiralStairStep(Random rand, Coord origin, IStair stair, IBlockFactory fill) {
        MetaBlock air = BlockType.get(BlockType.AIR);
        Coord start = new Coord(origin);
        start.translate(new Coord(-1, 0, -1));
        Coord end = new Coord(origin);
        end.translate(new Coord(1, 0, 1));
        RectSolid.fill(this, rand, start, end, air);
        fill.set(this, rand, origin);
        Cardinal dir = Cardinal.directions[origin.getY() % 4];
        Coord cursor = new Coord(origin);
        cursor.translate(dir);
        stair.setOrientation(dir.antiClockwise(), false).set(this, cursor);
        cursor.translate(dir.clockwise());
        stair.setOrientation(dir.clockwise(), true).set(this, cursor);
        cursor.translate(dir.reverse());
        stair.setOrientation(dir.reverse(), true).set(this, cursor);
    }

    public void fillDown(Random rand, Coord origin, IBlockFactory blocks) {
        Coord cursor = new Coord(origin);
        while (!this.getBlock(cursor).func_185914_p() && cursor.getY() > 1) {
            blocks.set(this, rand, cursor);
            cursor.translate(Cardinal.DOWN);
        }
    }

    public MetaBlock getBlock(Coord pos) {
        return new MetaBlock(this.world.func_180495_p(pos.getBlockPos()));
    }

    public TileEntity getTileEntity(Coord pos) {
        return this.world.func_175625_s(pos.getBlockPos());
    }

    public boolean validGroundBlock(Coord pos) {
        if (this.isAirBlock(pos)) {
            return false;
        }
        return !invalid.contains(this.getBlock(pos).func_185904_a());
    }

    public int getStat(Block type) {
        if (!this.stats.containsKey(type)) {
            return 0;
        }
        return this.stats.get(type);
    }

    public Map<Block, Integer> getStats() {
        return this.stats;
    }

    public boolean canPlace(MetaBlock block, Coord pos, Cardinal dir) {
        if (!this.isAirBlock(pos)) {
            return false;
        }
        return block.func_177230_c().func_176198_a(this.world, pos.getBlockPos(), dir.getFacing());
    }

    public IPositionInfo getInfo(Coord pos) {
        return new PositionInfo(this.world, pos);
    }

    public Coord findNearestStructure(VanillaStructure type, Coord pos) {
        ChunkProviderServer chunkProvider = ((WorldServer)this.world).func_72863_F();
        String structureName = VanillaStructure.getName(type);
        BlockPos structurebp = null;
        try {
            structurebp = chunkProvider.func_180513_a(this.world, structureName, pos.getBlockPos(), false);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (structurebp == null) {
            return null;
        }
        return new Coord(structurebp);
    }

    public String toString() {
        return this.stats.entrySet().stream().map(pair -> ((Block)pair.getKey()).func_149732_F() + ": " + pair.getValue() + "\n").collect(Collectors.joining());
    }

    public TreasureChestEditor getTreasureChestEditor() {
        return this.treasureChestEditor;
    }

    static {
        invalid.add(Material.field_151575_d);
        invalid.add(Material.field_151586_h);
        invalid.add(Material.field_151570_A);
        invalid.add(Material.field_151597_y);
        invalid.add(Material.field_151577_b);
        invalid.add(Material.field_151572_C);
        invalid.add(Material.field_151584_j);
        invalid.add(Material.field_151585_k);
    }
}

