/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.worldgen.shapes;

import greymerk.roguelike.worldgen.Cardinal;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.IBlockFactory;
import greymerk.roguelike.worldgen.WorldEditor;
import greymerk.roguelike.worldgen.shapes.IShape;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;

public class Ellipsoid
implements IShape {
    private Coord start;
    private Coord end;

    public Ellipsoid(Coord start, Coord end) {
        this.start = new Coord(start);
        this.end = new Coord(end);
    }

    @Override
    public Iterator<Coord> iterator() {
        return new EllipsoidIterator(this.start, this.end);
    }

    @Override
    public void fill(WorldEditor editor, Random rand, IBlockFactory block) {
        this.fill(editor, rand, block, true, true);
    }

    @Override
    public void fill(WorldEditor editor, Random rand, IBlockFactory block, boolean fillAir, boolean replaceSolid) {
        for (Coord pos : this) {
            block.set(editor, rand, pos, fillAir, replaceSolid);
        }
    }

    @Override
    public List<Coord> get() {
        ArrayList<Coord> copy = new ArrayList<Coord>();
        for (Coord pos : this) {
            copy.add(pos);
        }
        return copy;
    }

    private class EllipsoidIterator
    implements Iterator<Coord> {
        private Coord centre;
        private Coord diff;
        private Coord cursor;
        private Cardinal dir;
        private boolean top;

        public EllipsoidIterator(Coord centre, Coord end) {
            this.centre = new Coord(centre);
            Coord s = new Coord(centre);
            Coord e = new Coord(end);
            this.diff = e.translate(-s.getX(), -s.getY(), -s.getZ());
            this.diff = new Coord(Math.abs(this.diff.getX()), Math.abs(this.diff.getY()), Math.abs(this.diff.getZ()));
            this.cursor = new Coord(0, 0, 0);
            this.top = true;
            this.dir = Cardinal.NORTH;
        }

        @Override
        public boolean hasNext() {
            return this.cursor.getY() < this.diff.getY();
        }

        @Override
        public Coord next() {
            Coord toReturn = new Coord(this.centre);
            toReturn.translate(this.top ? Cardinal.UP : Cardinal.DOWN, this.cursor.getY());
            if (this.dir == Cardinal.NORTH || this.dir == Cardinal.SOUTH) {
                toReturn.translate(this.dir.antiClockwise(), this.cursor.getX());
                toReturn.translate(this.dir, this.cursor.getZ());
            } else {
                toReturn.translate(this.dir, this.cursor.getX());
                toReturn.translate(this.dir.antiClockwise(), this.cursor.getZ());
            }
            if (this.dir != Cardinal.NORTH || this.top) {
                if (this.dir == Cardinal.NORTH) {
                    this.top = false;
                }
                this.dir = this.dir.antiClockwise();
                return toReturn;
            }
            this.cursor.translate(Cardinal.SOUTH);
            if (this.inRange(this.cursor)) {
                this.dir = this.dir.antiClockwise();
                this.top = true;
                return toReturn;
            }
            this.cursor = new Coord(this.cursor.getX(), this.cursor.getY(), 0);
            this.cursor.translate(Cardinal.EAST);
            if (this.inRange(this.cursor)) {
                this.dir = this.dir.antiClockwise();
                this.top = true;
                return toReturn;
            }
            this.cursor = new Coord(0, this.cursor.getY(), this.cursor.getZ());
            this.cursor.translate(Cardinal.UP);
            this.dir = this.dir.antiClockwise();
            this.top = true;
            return toReturn;
        }

        private boolean inRange(Coord pos) {
            double x = pos.getX();
            double y = pos.getY();
            double z = pos.getZ();
            double rx = this.diff.getX() == 0 ? 1.0 : (double)this.diff.getX();
            double ry = this.diff.getY() == 0 ? 1.0 : (double)this.diff.getY();
            double rz = this.diff.getZ() == 0 ? 1.0 : (double)this.diff.getZ();
            return x / rx * (x / rx) + y / ry * (y / ry) + z / rz * (z / rz) <= 1.0;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

