/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.worldgen.shapes;

import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.IBlockFactory;
import greymerk.roguelike.worldgen.WorldEditor;
import greymerk.roguelike.worldgen.shapes.IShape;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;

public class MultiShape
implements IShape {
    private Set<Coord> shape = new HashSet<Coord>();

    public void addShape(IShape toAdd) {
        for (Coord pos : toAdd) {
            this.shape.add(pos);
        }
    }

    @Override
    public Iterator<Coord> iterator() {
        return this.shape.iterator();
    }

    @Override
    public void fill(WorldEditor editor, Random rand, IBlockFactory block) {
        this.fill(editor, rand, block, true, true);
    }

    @Override
    public void fill(WorldEditor editor, Random rand, IBlockFactory block, boolean fillAir, boolean replaceSolid) {
        for (Coord c : this) {
            block.set(editor, rand, c, fillAir, replaceSolid);
        }
    }

    @Override
    public List<Coord> get() {
        return this.shape.stream().map(Coord::new).collect(Collectors.toList());
    }
}

