/*
 * Decompiled with CFR 0.152.
 */
package noppes.vc.client;

import java.awt.Font;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import noppes.vc.VariedCommodities;
import noppes.vc.shared.util.TrueTypeFont;

public class FontContainer {
    private TrueTypeFont textFont = null;
    public boolean useCustomFont = true;

    public FontContainer() {
    }

    public FontContainer(String fontType, int fontSize) {
        this.textFont = new TrueTypeFont(new Font(fontType, 0, fontSize), 1.0f);
        this.useCustomFont = !fontType.equalsIgnoreCase("minecraft");
        try {
            if (!this.useCustomFont || fontType.isEmpty() || fontType.equalsIgnoreCase("default")) {
                this.textFont = new TrueTypeFont(new ResourceLocation("variedcommodities", "opensans.ttf"), fontSize, 1.0f);
            }
        }
        catch (Exception e) {
            VariedCommodities.Log.info("Failed loading font so using Arial");
        }
    }

    public int height(String text) {
        if (this.useCustomFont) {
            return this.textFont.height(text);
        }
        return Minecraft.func_71410_x().field_71466_p.field_78288_b;
    }

    public int width(String text) {
        if (this.useCustomFont) {
            return this.textFont.width(text);
        }
        return Minecraft.func_71410_x().field_71466_p.func_78256_a(text);
    }

    public FontContainer copy() {
        FontContainer font = new FontContainer();
        font.textFont = this.textFont;
        font.useCustomFont = this.useCustomFont;
        return font;
    }

    public void drawString(String text, int x, int y, int color) {
        if (this.useCustomFont) {
            this.textFont.draw(text, x, y, color);
        } else {
            Minecraft.func_71410_x().field_71466_p.func_175063_a(text, (float)x, (float)y, color);
        }
    }

    public String getName() {
        if (!this.useCustomFont) {
            return "Minecraft";
        }
        return this.textFont.getFontName();
    }

    public void clear() {
        if (this.textFont != null) {
            this.textFont.dispose();
        }
    }
}

