/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.api2.supporter;

import betterquesting.api2.storage.INBTSaveLoad;
import betterquesting.api2.supporter.SupporterEntry;
import betterquesting.core.BetterQuesting;
import java.util.TreeMap;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class SupporterDB
implements INBTSaveLoad<NBTTagCompound> {
    public static final SupporterDB INSTANCE = new SupporterDB();
    private final TreeMap<UUID, SupporterEntry> mapDB = new TreeMap();

    public synchronized SupporterEntry add(@Nonnull UUID playerID) {
        SupporterEntry entry = new SupporterEntry();
        if (this.mapDB.putIfAbsent(playerID, entry) != null) {
            BetterQuesting.logger.warn("Tried to add duplicate supporter to DB: " + playerID.toString());
            return this.mapDB.get(playerID);
        }
        return entry;
    }

    public synchronized boolean removeID(@Nonnull UUID playerID) {
        return this.mapDB.remove(playerID) != null;
    }

    @Nullable
    public synchronized SupporterEntry getValue(@Nonnull UUID playerID) {
        return this.mapDB.get(playerID);
    }

    @Override
    @Nonnull
    public synchronized NBTTagCompound writeToNBT(@Nonnull NBTTagCompound nbt) {
        this.mapDB.forEach((key, value) -> nbt.func_74782_a(key.toString(), (NBTBase)value.writeToNBT(new NBTTagCompound())));
        return nbt;
    }

    @Override
    public synchronized void readFromNBT(@Nonnull NBTTagCompound nbt) {
        this.mapDB.clear();
        nbt.func_150296_c().forEach(key -> {
            try {
                SupporterEntry entry = new SupporterEntry();
                entry.readFromNBT(nbt.func_74775_l(key));
                this.mapDB.put(UUID.fromString(key), entry);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }
}

