/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.network.handlers;

import betterquesting.api.events.DatabaseEvent;
import betterquesting.api.network.QuestingPacket;
import betterquesting.api.questing.party.IParty;
import betterquesting.core.BetterQuesting;
import betterquesting.network.PacketSender;
import betterquesting.network.PacketTypeRegistry;
import betterquesting.questing.party.PartyManager;
import betterquesting.storage.NameCache;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import net.minecraft.util.Tuple;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class NetNameSync {
    private static final ResourceLocation ID_NAME = new ResourceLocation("betterquesting:name_sync");

    public static void registerHandler() {
        PacketTypeRegistry.INSTANCE.registerServerHandler(ID_NAME, NetNameSync::onServer);
        if (BetterQuesting.proxy.isClient()) {
            PacketTypeRegistry.INSTANCE.registerClientHandler(ID_NAME, NetNameSync::onClient);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void sendRequest(@Nullable UUID[] uuids, @Nullable String[] names) {
        NBTTagCompound payload = new NBTTagCompound();
        if (uuids != null) {
            NBTTagList uList = new NBTTagList();
            for (UUID id : uuids) {
                if (id == null) continue;
                uList.func_74742_a((NBTBase)new NBTTagString(id.toString()));
            }
            payload.func_74782_a("uuids", (NBTBase)uList);
        }
        if (names != null) {
            NBTTagList nList = new NBTTagList();
            for (String s : names) {
                if (StringUtils.func_151246_b((String)s)) continue;
                nList.func_74742_a((NBTBase)new NBTTagString(s));
            }
            payload.func_74782_a("names", (NBTBase)nList);
        }
        PacketSender.INSTANCE.sendToServer(new QuestingPacket(ID_NAME, payload));
    }

    public static void quickSync(@Nullable EntityPlayerMP player, int partyID) {
        IParty party = (IParty)PartyManager.INSTANCE.getValue(partyID);
        if (party == null) {
            return;
        }
        NBTTagCompound payload = new NBTTagCompound();
        payload.func_74782_a("data", (NBTBase)NameCache.INSTANCE.writeToNBT(new NBTTagList(), party.getMembers()));
        payload.func_74757_a("merge", true);
        if (player != null) {
            PacketSender.INSTANCE.sendToPlayers(new QuestingPacket(ID_NAME, payload), player);
        } else {
            MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
            ArrayList<EntityPlayerMP> playerList = new ArrayList<EntityPlayerMP>();
            for (UUID playerID : party.getMembers()) {
                EntityPlayerMP p = server.func_184103_al().func_177451_a(playerID);
                if (p == null) continue;
                playerList.add(p);
            }
            PacketSender.INSTANCE.sendToPlayers(new QuestingPacket(ID_NAME, payload), playerList.toArray(new EntityPlayerMP[0]));
        }
    }

    public static void sendNames(@Nullable EntityPlayerMP[] players, @Nullable UUID[] uuids, @Nullable String[] names) {
        ArrayList<UUID> idList;
        ArrayList<UUID> arrayList = idList = uuids == null && names == null ? null : new ArrayList<UUID>();
        if (uuids != null) {
            idList.addAll(Arrays.asList(uuids));
        }
        if (names != null) {
            for (String s : names) {
                UUID id = NameCache.INSTANCE.getUUID(s);
                if (id == null) continue;
                idList.add(id);
            }
        }
        NBTTagCompound payload = new NBTTagCompound();
        payload.func_74782_a("data", (NBTBase)NameCache.INSTANCE.writeToNBT(new NBTTagList(), (List<UUID>)idList));
        payload.func_74757_a("merge", idList != null);
        if (players == null) {
            PacketSender.INSTANCE.sendToAll(new QuestingPacket(ID_NAME, payload));
        } else {
            PacketSender.INSTANCE.sendToPlayers(new QuestingPacket(ID_NAME, payload), players);
        }
    }

    private static void onServer(Tuple<NBTTagCompound, EntityPlayerMP> message) {
        int i;
        NBTTagList uList;
        UUID[] uuids = null;
        String[] names = null;
        if (((NBTTagCompound)message.func_76341_a()).func_150297_b("uuids", 9)) {
            uList = ((NBTTagCompound)message.func_76341_a()).func_150295_c("uuids", 8);
            uuids = new UUID[uList.func_74745_c()];
            for (i = 0; i < uuids.length; ++i) {
                try {
                    uuids[i] = UUID.fromString(uList.func_150307_f(i));
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (((NBTTagCompound)message.func_76341_a()).func_150297_b("names", 9)) {
            uList = ((NBTTagCompound)message.func_76341_a()).func_150295_c("names", 8);
            names = new String[uList.func_74745_c()];
            for (i = 0; i < names.length; ++i) {
                names[i] = uList.func_150307_f(i);
            }
        }
        NetNameSync.sendNames(new EntityPlayerMP[]{(EntityPlayerMP)message.func_76340_b()}, uuids, names);
    }

    @SideOnly(value=Side.CLIENT)
    private static void onClient(NBTTagCompound message) {
        NameCache.INSTANCE.readFromNBT(message.func_150295_c("data", 10), message.func_74767_n("merge"));
        MinecraftForge.EVENT_BUS.post((Event)new DatabaseEvent.Update(DatabaseEvent.DBType.NAMES));
    }
}

