/*
 * Decompiled with CFR 0.152.
 */
package locusway.colorfulhealthbar;

import locusway.colorfulhealthbar.ModConfig;
import locusway.colorfulhealthbar.overlay.HealthBarRenderer;
import locusway.colorfulhealthbar.overlay.OverlayEventHandler;
import net.minecraft.client.Minecraft;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.Logger;

@Mod(modid="colorfulhealthbar", name="Colorful Health Bar", version="@VERSION@", useMetadata=true, clientSideOnly=true, acceptedMinecraftVersions="[1.12.2]")
@Mod.EventBusSubscriber(value={Side.CLIENT})
public class ColorfulHealthBar {
    public static final String MODID = "colorfulhealthbar";
    public static final String MODNAME = "Colorful Health Bar";
    public static final String MODVERSION = "@VERSION@";
    public static Logger logger;
    private static HealthBarRenderer healthBarRenderer;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger = event.getModLog();
        if (ModConfig.healthColorValues.length == 0) {
            logger.error("Config error! No health colors specified in config");
            logger.error("Health bar will not display correctly.");
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        healthBarRenderer = new HealthBarRenderer(Minecraft.func_71410_x());
        OverlayEventHandler overlay = new OverlayEventHandler(healthBarRenderer);
        MinecraftForge.EVENT_BUS.register((Object)overlay);
    }

    @SubscribeEvent
    public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        ConfigManager.sync((String)MODID, (Config.Type)Config.Type.INSTANCE);
        healthBarRenderer.forceUpdate();
    }
}

