/*
 * Decompiled with CFR 0.152.
 */
package locusway.colorfulhealthbar.overlay;

import java.util.Random;
import locusway.colorfulhealthbar.ModConfig;
import locusway.colorfulhealthbar.overlay.Icon;
import locusway.colorfulhealthbar.overlay.IconColor;
import locusway.colorfulhealthbar.overlay.IconStateCalculator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.GuiIngameForge;

public class HealthBarRenderer {
    private Minecraft mc;
    private int updateCounter = 0;
    private int playerHealth = 0;
    private int lastPlayerHealth = 0;
    private long healthUpdateCounter = 0L;
    private long lastSystemTime = 0L;
    private Random rand = new Random();
    private Icon[] healthIcons;
    private Icon[] absorbIcons;
    private static final ResourceLocation ICON_HEARTS = new ResourceLocation("colorfulhealthbar", "textures/gui/health.png");
    private static final ResourceLocation ICON_ABSORPTION = new ResourceLocation("colorfulhealthbar", "textures/gui/absorption.png");
    private static final ResourceLocation ICON_VANILLA = Gui.field_110324_m;
    private static final float PASS_ONE_ALPHA = 1.0f;
    private static final float PASS_TWO_ALPHA = 0.2647f;
    private static final float PASS_THREE_ALPHA = 0.769f;
    private static final float PASS_FOUR_ALPHA = 0.63f;
    private static final float POTION_ALPHA = 0.85f;
    private static final float PASS_SIX_ALPHA = 0.2f;
    private boolean forceUpdateIcons = false;

    public void drawTexturedModalRect(int x, int y, int textureX, int textureY, int width, int height) {
        this.mc.field_71456_v.func_73729_b(x, y, textureX, textureY, width, height);
    }

    public HealthBarRenderer(Minecraft mc) {
        this.mc = mc;
    }

    public void forceUpdate() {
        this.forceUpdateIcons = true;
    }

    public void renderHealthBar(int screenWidth, int screenHeight) {
        int i5;
        int yPosition;
        int xPosition;
        int j4;
        int i;
        boolean highlight;
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        this.updateCounter = this.mc.field_71456_v.func_73834_c();
        EntityPlayer entityplayer = (EntityPlayer)this.mc.func_175606_aa();
        IAttributeInstance maxHealthAttribute = entityplayer.func_110148_a(SharedMonsterAttributes.field_111267_a);
        double maxHealth = Math.ceil(maxHealthAttribute.func_111126_e());
        int health = MathHelper.func_76143_f((double)Math.min((double)entityplayer.func_110143_aJ(), maxHealth));
        boolean bl = highlight = this.healthUpdateCounter > (long)this.updateCounter && (this.healthUpdateCounter - (long)this.updateCounter) / 3L % 2L == 1L;
        if (health < this.playerHealth && entityplayer.field_70172_ad > 0) {
            this.lastSystemTime = Minecraft.func_71386_F();
            this.healthUpdateCounter = this.updateCounter + 20;
        } else if (health > this.playerHealth && entityplayer.field_70172_ad > 0) {
            this.lastSystemTime = Minecraft.func_71386_F();
            this.healthUpdateCounter = this.updateCounter + 10;
        }
        if (Minecraft.func_71386_F() - this.lastSystemTime > 1000L) {
            this.playerHealth = health;
            this.lastPlayerHealth = health;
            this.lastSystemTime = Minecraft.func_71386_F();
        }
        int absorb = MathHelper.func_76123_f((float)entityplayer.func_110139_bj());
        if (health != this.playerHealth || this.absorbIcons == null || this.healthIcons == null || this.forceUpdateIcons) {
            this.healthIcons = IconStateCalculator.calculateIcons(health, ModConfig.healthColorValues);
            this.absorbIcons = IconStateCalculator.calculateIcons(absorb, ModConfig.absorptionColorValues);
            this.forceUpdateIcons = false;
        }
        this.playerHealth = health;
        int j = this.lastPlayerHealth;
        this.rand.setSeed(this.updateCounter * 312871);
        int xStart = screenWidth / 2 - 91;
        int yStart = screenHeight - 39;
        maxHealth = maxHealthAttribute.func_111126_e();
        int numberOfHealthBars = Math.min(MathHelper.func_76143_f((double)((maxHealth + (double)absorb) / 20.0)), 2);
        int i2 = Math.max(10 - (numberOfHealthBars - 2), 3);
        int regen = -1;
        if (entityplayer.func_70644_a(MobEffects.field_76428_l)) {
            regen = this.updateCounter % MathHelper.func_76143_f((double)(maxHealth + 5.0));
        }
        this.mc.field_71424_I.func_76320_a("health");
        for (i = 9; i >= 0; --i) {
            this.healthIcons = IconStateCalculator.calculateIcons(health, ModConfig.healthColorValues);
            Icon icon = this.healthIcons[i];
            IconColor firstHalfColor = icon.primaryIconColor;
            IconColor secondHalfColor = icon.secondaryIconColor;
            int k5 = 16;
            if (entityplayer.func_70644_a(MobEffects.field_76436_u)) {
                k5 += 36;
            } else if (entityplayer.func_70644_a(MobEffects.field_82731_v)) {
                k5 += 72;
            }
            int i4 = highlight ? 1 : 0;
            j4 = MathHelper.func_76123_f((float)((float)(i + 1) / 10.0f)) - 1;
            xPosition = xStart + i % 10 * 8;
            yPosition = yStart - j4 * i2;
            if (health <= 4) {
                yPosition += this.rand.nextInt(2);
            }
            if (absorb <= 0 && i == regen) {
                yPosition -= 2;
            }
            int n = i5 = entityplayer.field_70170_p.func_72912_H().func_76093_s() ? 5 : 0;
            if ((double)(i * 2) < maxHealth) {
                this.drawTexturedModalRect(xPosition, yPosition, 16 + i4 * 9, 9 * i5, 9, 9);
            }
            if (highlight) {
                if (i * 2 + 1 < j) {
                    this.drawTexturedModalRect(xPosition, yPosition, k5 + 54, 9 * i5, 9, 9);
                }
                if (i * 2 + 1 == j) {
                    this.drawTexturedModalRect(xPosition, yPosition, k5 + 63, 9 * i5, 9, 9);
                }
            }
            if (icon.iconType == Icon.Type.FULL) {
                this.mc.func_110434_K().func_110577_a(ICON_HEARTS);
                GlStateManager.func_179131_c((float)firstHalfColor.Red, (float)firstHalfColor.Green, (float)firstHalfColor.Blue, (float)1.0f);
                this.drawTexturedModalRect(xPosition, yPosition, 0, 0, 9, 9);
                GlStateManager.func_179131_c((float)firstHalfColor.Red, (float)firstHalfColor.Green, (float)firstHalfColor.Blue, (float)0.2647f);
                this.drawTexturedModalRect(xPosition, yPosition, 0, 9, 9, 9);
                if (i5 == 5) {
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.63f);
                    this.drawTexturedModalRect(xPosition, yPosition, 0, 18, 9, 9);
                } else {
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.769f);
                    this.drawTexturedModalRect(xPosition, yPosition, 27, 0, 9, 9);
                }
                this.mc.func_110434_K().func_110577_a(ICON_VANILLA);
                if (k5 != 16) {
                    this.potionEffects(xPosition, yPosition, k5, i, health);
                }
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            if (icon.iconType != Icon.Type.HALF) continue;
            if (health > 20) {
                this.mc.func_110434_K().func_110577_a(ICON_HEARTS);
                GlStateManager.func_179131_c((float)firstHalfColor.Red, (float)firstHalfColor.Green, (float)firstHalfColor.Blue, (float)1.0f);
                this.drawTexturedModalRect(xPosition, yPosition, 9, 0, 9, 9);
                GlStateManager.func_179131_c((float)firstHalfColor.Red, (float)firstHalfColor.Green, (float)firstHalfColor.Blue, (float)0.2647f);
                this.drawTexturedModalRect(xPosition, yPosition, 9, 9, 9, 9);
                if (i5 == 5) {
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.63f);
                    this.drawTexturedModalRect(xPosition, yPosition, 0, 18, 9, 9);
                } else {
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.769f);
                    this.drawTexturedModalRect(xPosition, yPosition, 27, 0, 9, 9);
                }
                GlStateManager.func_179131_c((float)secondHalfColor.Red, (float)secondHalfColor.Green, (float)secondHalfColor.Blue, (float)1.0f);
                this.drawTexturedModalRect(xPosition, yPosition, 18, 0, 9, 9);
                GlStateManager.func_179131_c((float)secondHalfColor.Red, (float)secondHalfColor.Green, (float)secondHalfColor.Blue, (float)0.2647f);
                this.drawTexturedModalRect(xPosition, yPosition, 18, 9, 9, 9);
                if (i5 == 5) {
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.63f);
                    this.drawTexturedModalRect(xPosition, yPosition, 0, 18, 9, 9);
                } else {
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.769f);
                    this.drawTexturedModalRect(xPosition, yPosition, 27, 0, 9, 9);
                }
            } else {
                this.mc.func_110434_K().func_110577_a(ICON_HEARTS);
                GlStateManager.func_179131_c((float)firstHalfColor.Red, (float)firstHalfColor.Green, (float)firstHalfColor.Blue, (float)1.0f);
                this.drawTexturedModalRect(xPosition, yPosition, 9, 0, 9, 9);
                GlStateManager.func_179131_c((float)firstHalfColor.Red, (float)firstHalfColor.Green, (float)firstHalfColor.Blue, (float)0.2647f);
                this.drawTexturedModalRect(xPosition, yPosition, 9, 9, 9, 9);
                if (i5 == 5) {
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.63f);
                    this.drawTexturedModalRect(xPosition, yPosition, 9, 18, 9, 9);
                } else {
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.769f);
                    this.drawTexturedModalRect(xPosition, yPosition, 27, 0, 9, 9);
                }
            }
            this.mc.func_110434_K().func_110577_a(ICON_VANILLA);
            if (k5 != 16) {
                this.potionEffects(xPosition, yPosition, k5, i, health);
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        if (absorb > 0) {
            for (i = 9; i >= 0; --i) {
                if (absorb / 2 < i) continue;
                int absorbCap = absorb % 20;
                int offset = 10;
                Icon icon2 = this.absorbIcons[i];
                this.absorbIcons = IconStateCalculator.calculateIcons(absorb, ModConfig.absorptionColorValues);
                IconColor firstHalfColor = icon2.primaryIconColor;
                IconColor secondHalfColor = icon2.secondaryIconColor;
                if (entityplayer.func_70644_a(MobEffects.field_76436_u) || entityplayer.func_70644_a(MobEffects.field_82731_v)) {
                    // empty if block
                }
                j4 = MathHelper.func_76123_f((float)((float)(i + 1) / 10.0f)) - 1;
                xPosition = xStart + i % 10 * 8;
                yPosition = yStart - j4 * i2;
                int n = i5 = entityplayer.field_70170_p.func_72912_H().func_76093_s() ? 5 : 0;
                if (i * 2 + 1 < absorb) {
                    this.mc.func_110434_K().func_110577_a(ICON_ABSORPTION);
                    GlStateManager.func_179131_c((float)firstHalfColor.Red, (float)firstHalfColor.Green, (float)firstHalfColor.Blue, (float)1.0f);
                    this.drawTexturedModalRect(xPosition, yPosition - offset, 0, 0, 9, 9);
                    GlStateManager.func_179131_c((float)firstHalfColor.Red, (float)firstHalfColor.Green, (float)firstHalfColor.Blue, (float)0.2647f);
                    this.drawTexturedModalRect(xPosition, yPosition - offset, 0, 9, 9, 9);
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.2f);
                    this.drawTexturedModalRect(xPosition, yPosition - offset, 27, 0, 9, 9);
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    this.mc.func_110434_K().func_110577_a(ICON_VANILLA);
                }
                if (i * 2 + 1 != absorbCap) continue;
                if (absorb > 20) {
                    this.mc.func_110434_K().func_110577_a(ICON_ABSORPTION);
                    GlStateManager.func_179131_c((float)firstHalfColor.Red, (float)firstHalfColor.Green, (float)firstHalfColor.Blue, (float)1.0f);
                    this.drawTexturedModalRect(xPosition, yPosition - offset, 9, 0, 9, 9);
                    GlStateManager.func_179131_c((float)firstHalfColor.Red, (float)firstHalfColor.Green, (float)firstHalfColor.Blue, (float)0.2647f);
                    this.drawTexturedModalRect(xPosition, yPosition - offset, 9, 9, 9, 9);
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.2f);
                    this.drawTexturedModalRect(xPosition, yPosition - offset, 27, 0, 9, 9);
                    GlStateManager.func_179131_c((float)secondHalfColor.Red, (float)secondHalfColor.Green, (float)secondHalfColor.Blue, (float)1.0f);
                    this.drawTexturedModalRect(xPosition, yPosition - offset, 18, 0, 9, 9);
                    GlStateManager.func_179131_c((float)secondHalfColor.Red, (float)secondHalfColor.Green, (float)secondHalfColor.Blue, (float)0.2647f);
                    this.drawTexturedModalRect(xPosition, yPosition - offset, 18, 9, 9, 9);
                } else {
                    this.mc.func_110434_K().func_110577_a(ICON_ABSORPTION);
                    GlStateManager.func_179131_c((float)firstHalfColor.Red, (float)firstHalfColor.Green, (float)firstHalfColor.Blue, (float)1.0f);
                    this.drawTexturedModalRect(xPosition, yPosition - offset, 9, 0, 9, 9);
                    GlStateManager.func_179131_c((float)firstHalfColor.Red, (float)firstHalfColor.Green, (float)firstHalfColor.Blue, (float)0.2647f);
                    this.drawTexturedModalRect(xPosition, yPosition - offset, 9, 9, 9, 9);
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.2f);
                    this.drawTexturedModalRect(xPosition, yPosition - offset, 27, 0, 9, 9);
                }
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.mc.func_110434_K().func_110577_a(ICON_VANILLA);
            }
        }
        GlStateManager.func_179084_k();
        GlStateManager.func_179139_a((double)ModConfig.textScale, (double)ModConfig.textScale, (double)1.0);
        int index = (int)Math.max(Math.ceil((float)health / 20.0f), 1.0);
        int textOffset = this.mc.field_71466_p.func_78256_a(index + "x");
        if (ModConfig.showIndex) {
            this.drawStringOnHUD(index + "x", xStart - textOffset - 1, yStart, Integer.decode(ModConfig.healthColorValues[Math.min(index - 1, ModConfig.healthColorValues.length - 1)]), (float)ModConfig.textScale);
        }
        if (absorb > 0 && ModConfig.showAbsorptionIndex) {
            this.drawStringOnHUD((int)Math.ceil((double)absorb / 20.0) + "x", xStart - textOffset - 1, yStart - 10, Integer.decode(ModConfig.absorptionColorValues[Math.min((int)Math.ceil((double)absorb / 20.0) - 1, ModConfig.absorptionColorValues.length - 1)]), (float)ModConfig.textScale);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179152_a((float)1.0f, (float)1.0f, (float)1.0f);
        this.mc.func_110434_K().func_110577_a(ICON_VANILLA);
        GuiIngameForge.left_height += 10;
        if (absorb > 0) {
            GuiIngameForge.left_height += 10;
        }
        GlStateManager.func_179121_F();
        this.mc.field_71424_I.func_76319_b();
    }

    public void potionEffects(int x, int y, int k5, int i, int health) {
        if (k5 == 52) {
            if (i * 2 + 1 != health || health >= 20) {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.85f);
                this.drawTexturedModalRect(x, y, 88, 0, 9, 9);
            } else {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.85f);
                this.drawTexturedModalRect(x, y, 97, 0, 9, 9);
            }
        }
        if (k5 == 88) {
            if (i * 2 + 1 != health || health >= 20) {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.85f);
                this.drawTexturedModalRect(x, y, 124, 0, 9, 9);
            } else {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.85f);
                this.drawTexturedModalRect(x, y, 133, 0, 9, 9);
            }
        }
    }

    public void drawStringOnHUD(String string, int xOffset, int yOffset, int color, float scale) {
        yOffset = (int)((float)yOffset + 9.0f * (1.0f - scale));
        xOffset = (int)((float)xOffset + 9.0f * (1.0f - scale));
        this.mc.field_71466_p.func_175065_a(string, (float)xOffset / scale, (float)yOffset / scale, color, true);
    }
}

