/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftimebuilder;

import java.io.File;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import org.apache.logging.log4j.Logger;
import org.dawnoftimebuilder.DoTBConfigs;
import org.dawnoftimebuilder.DoTBEvents;
import org.dawnoftimebuilder.DoTBWorldGen;
import org.dawnoftimebuilder.blocks.DoTBBlocks;
import org.dawnoftimebuilder.client.gui.DoTGuiHandler;
import org.dawnoftimebuilder.crafts.OreDictionaryHandler;
import org.dawnoftimebuilder.proxy.CommonProxy;
import org.dawnoftimebuilder.registries.DoTBBlocksRegistry;
import org.dawnoftimebuilder.registries.DoTBEntitiesRegistry;
import org.dawnoftimebuilder.registries.DoTBItemsRegistry;
import org.dawnoftimebuilder.registries.DoTBRecipesRegistry;
import org.dawnoftimebuilder.registries.DoTBTileEntitiesRegistry;

@Mod(modid="dawnoftimebuilder", name="Dawn Of Time : Builder Edition", version="1.0.6", updateJSON="https://raw.githubusercontent.com/Poulpynou/dawnoftimebuilder/master-1.12.2/update.json", acceptedMinecraftVersions="[1.12.2]")
public class DawnOfTimeBuilder {
    public static final String MOD_ID = "dawnoftimebuilder";
    public static final String NAME = "Dawn Of Time : Builder Edition";
    public static final String VERSION = "1.0.6";
    public static Logger logger;
    public static final NetworkRegistry NETWORK;
    @Mod.Instance(value="dawnoftimebuilder")
    public static DawnOfTimeBuilder instance;
    @SidedProxy(clientSide="org.dawnoftimebuilder.proxy.ClientProxy", serverSide="org.dawnoftimebuilder.proxy.ServerProxy")
    public static CommonProxy proxy;
    public static final CreativeTabs DOTB_TAB;

    public DawnOfTimeBuilder() {
        MinecraftForge.EVENT_BUS.register((Object)new DoTBEvents());
        MinecraftForge.TERRAIN_GEN_BUS.register((Object)new DoTBWorldGen());
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger = event.getModLog();
        DoTBBlocksRegistry.init();
        DoTBItemsRegistry.init();
        DoTBTileEntitiesRegistry.init();
        DoTBEntitiesRegistry.init();
        DoTBConfigs.init(new File(event.getModConfigurationDirectory(), "dawnoftimebuilder_disabled_objects.cfg"));
        proxy.preInit(event.getSuggestedConfigurationFile());
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        OreDictionaryHandler.init();
        NETWORK.registerGuiHandler((Object)instance, (IGuiHandler)new DoTGuiHandler());
        proxy.init();
        DoTBRecipesRegistry.init();
    }

    static {
        NETWORK = NetworkRegistry.INSTANCE;
        DOTB_TAB = new CreativeTabs(MOD_ID){

            public ItemStack func_78016_d() {
                return new ItemStack(DoTBBlocks.cast_iron_teapot);
            }

            public void func_78018_a(NonNullList<ItemStack> p_78018_1_) {
                super.func_78018_a(p_78018_1_);
            }
        };
    }
}

