/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftimebuilder;

import java.io.File;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraftforge.common.config.Configuration;
import org.dawnoftimebuilder.registries.DoTBBlocksRegistry;
import org.dawnoftimebuilder.registries.DoTBItemsRegistry;

public class DoTBConfigs {
    public static Configuration config;
    public static HashMap<String, Boolean> enabledMap;

    public static void init(File configFile) {
        if (config == null) {
            config = new Configuration(configFile);
            DoTBConfigs.loadConfig();
        }
    }

    public static void loadConfig() {
        Boolean enabled;
        String name;
        String configName = "Blocks";
        config.setCategoryComment(configName, "Disable Blocks from this group.");
        for (Block block : DoTBBlocksRegistry.blocks_list) {
            name = block.getRegistryName().func_110623_a();
            enabled = config.get(configName, name, true).getBoolean();
            enabledMap.put(name, enabled);
        }
        configName = "Items";
        config.setCategoryComment(configName, "Disable Items from this group.");
        for (Item item : DoTBItemsRegistry.items_list) {
            name = item.getRegistryName().func_110623_a();
            if (enabledMap.containsKey(name)) continue;
            enabled = config.get(configName, name, true).getBoolean();
            enabledMap.put(name, enabled);
        }
        if (config.hasChanged()) {
            config.save();
        }
    }

    static {
        enabledMap = new HashMap();
    }
}

