/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftimebuilder.blocks.general;

import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.dawnoftimebuilder.blocks.IBlockCustomItem;
import org.dawnoftimebuilder.blocks.general.DoTBBlock;
import org.dawnoftimebuilder.items.general.DoTBItemSlab;

public class DoTBBlockSlab
extends DoTBBlock
implements IBlockCustomItem {
    protected static final PropertyEnum<EnumSlab> SLAB = PropertyEnum.func_177709_a((String)"slab", EnumSlab.class);
    static final AxisAlignedBB AABB_BOTTOM = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);
    static final AxisAlignedBB AABB_TOP = new AxisAlignedBB(0.0, 0.5, 0.0, 1.0, 1.0, 1.0);

    public DoTBBlockSlab(String name, Material materialIn, float hardness, SoundType sound) {
        super(name, materialIn, hardness, sound);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(SLAB, (Comparable)((Object)EnumSlab.BOTTOM)));
        this.func_149713_g(255);
        this.field_149783_u = true;
    }

    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{SLAB});
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        IBlockState state = super.func_180642_a(worldIn, pos, facing, hitX, hitY, hitZ, meta, placer).func_177226_a(SLAB, (Comparable)((Object)EnumSlab.BOTTOM));
        return facing != EnumFacing.DOWN && (facing == EnumFacing.UP || (double)hitY <= 0.5) ? state : state.func_177226_a(SLAB, (Comparable)((Object)EnumSlab.TOP));
    }

    protected boolean func_149700_E() {
        return false;
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        drops.add((Object)new ItemStack(Item.func_150898_a((Block)this), 1));
        if (state.func_177229_b(SLAB) == EnumSlab.DOUBLE) {
            drops.add((Object)new ItemStack(Item.func_150898_a((Block)this), 1));
        }
    }

    public int func_176201_c(IBlockState state) {
        switch ((EnumSlab)((Object)state.func_177229_b(SLAB))) {
            default: {
                return 0;
            }
            case TOP: {
                return 1;
            }
            case DOUBLE: 
        }
        return 2;
    }

    public IBlockState func_176203_a(int meta) {
        switch (meta) {
            default: {
                return this.func_176223_P().func_177226_a(SLAB, (Comparable)((Object)EnumSlab.BOTTOM));
            }
            case 1: {
                return this.func_176223_P().func_177226_a(SLAB, (Comparable)((Object)EnumSlab.TOP));
            }
            case 2: 
        }
        return this.func_176223_P().func_177226_a(SLAB, (Comparable)((Object)EnumSlab.DOUBLE));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        switch ((EnumSlab)((Object)state.func_177229_b(SLAB))) {
            default: {
                return AABB_BOTTOM;
            }
            case TOP: {
                return AABB_TOP;
            }
            case DOUBLE: 
        }
        return field_185505_j;
    }

    public boolean func_149662_c(IBlockState state) {
        return state.func_177229_b(SLAB) == EnumSlab.DOUBLE;
    }

    public boolean func_149686_d(IBlockState state) {
        return state.func_177229_b(SLAB) == EnumSlab.DOUBLE;
    }

    public boolean isSideSolid(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return this.func_193383_a(world, state, pos, side) == BlockFaceShape.SOLID;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing side) {
        if (state.func_177229_b(SLAB) == EnumSlab.DOUBLE) {
            return BlockFaceShape.SOLID;
        }
        if (side == EnumFacing.DOWN && state.func_177229_b(SLAB) == EnumSlab.BOTTOM) {
            return BlockFaceShape.SOLID;
        }
        if (side == EnumFacing.UP && state.func_177229_b(SLAB) == EnumSlab.TOP) {
            return BlockFaceShape.SOLID;
        }
        return BlockFaceShape.UNDEFINED;
    }

    @Override
    public Item getCustomItemBlock() {
        return new DoTBItemSlab(this);
    }

    public EnumSlab getSlabState(IBlockState state) {
        return (EnumSlab)((Object)state.func_177229_b(SLAB));
    }

    public IBlockState getDoubleSlabDefaultState() {
        return this.func_176223_P().func_177226_a(SLAB, (Comparable)((Object)EnumSlab.DOUBLE));
    }

    public static enum EnumSlab implements IStringSerializable
    {
        BOTTOM("bottom"),
        TOP("top"),
        DOUBLE("double");

        private final String name;

        private EnumSlab(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

