/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftimebuilder.blocks.japanese;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.dawnoftimebuilder.DoTBUtils;
import org.dawnoftimebuilder.blocks.IBlockCustomItem;
import org.dawnoftimebuilder.blocks.general.DoTBBlock;
import org.dawnoftimebuilder.items.DoTBItems;
import org.dawnoftimebuilder.items.japanese.ItemPaperDoor;

public class BlockPaperDoor
extends DoTBBlock
implements IBlockCustomItem {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    public static final PropertyBool OPEN = PropertyBool.func_177716_a((String)"open");
    public static final PropertyEnum<EnumHingePosition> HINGE = PropertyEnum.func_177709_a((String)"hinge", EnumHingePosition.class);
    public static final PropertyBool POWERED = PropertyBool.func_177716_a((String)"powered");
    public static final PropertyEnum<EnumDoorHalf> HALF = PropertyEnum.func_177709_a((String)"half", EnumDoorHalf.class);
    private static final AxisAlignedBB NORTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.4374, 1.0, 1.0, 0.5626);
    private static final AxisAlignedBB NORTH_OPEN_AABB = new AxisAlignedBB(0.0, 0.0, 0.4374, 0.25, 1.0, 0.5626);

    public BlockPaperDoor() {
        super("paper_door", Material.field_151580_n);
        this.setBurnable();
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)OPEN, (Comparable)Boolean.valueOf(false)).func_177226_a(HINGE, (Comparable)((Object)EnumHingePosition.LEFT)).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)).func_177226_a(HALF, (Comparable)((Object)EnumDoorHalf.LOWER)));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        state = state.func_185899_b(source, pos);
        boolean open = (Boolean)state.func_177229_b((IProperty)OPEN);
        boolean hinge = state.func_177229_b(HINGE) == EnumHingePosition.RIGHT;
        return DoTBUtils.getRotatedAABB(open ? NORTH_OPEN_AABB : NORTH_AABB, hinge ? ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176734_d() : (EnumFacing)state.func_177229_b((IProperty)FACING));
    }

    public String func_149732_F() {
        return I18n.func_74838_a((String)(this.func_149739_a() + ".name").replaceAll("tile", "item"));
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return BlockPaperDoor.isOpen(BlockPaperDoor.combineMetadata(worldIn, pos));
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    private int getCloseSound() {
        return 1012;
    }

    private int getOpenSound() {
        return 1006;
    }

    public MapColor func_180659_g(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return MapColor.field_193561_M;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        IBlockState iblockstate;
        BlockPos blockpos = state.func_177229_b(HALF) == EnumDoorHalf.LOWER ? pos : pos.func_177977_b();
        IBlockState iBlockState = iblockstate = pos.equals((Object)blockpos) ? state : worldIn.func_180495_p(blockpos);
        if (iblockstate.func_177230_c() != this) {
            return false;
        }
        state = iblockstate.func_177231_a((IProperty)OPEN);
        worldIn.func_180501_a(blockpos, state, 10);
        worldIn.func_175704_b(blockpos, pos);
        worldIn.func_180498_a(playerIn, (Boolean)state.func_177229_b((IProperty)OPEN) != false ? this.getOpenSound() : this.getCloseSound(), pos, 0);
        return true;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (state.func_177229_b(HALF) == EnumDoorHalf.UPPER) {
            BlockPos posDown = pos.func_177977_b();
            IBlockState stateDown = worldIn.func_180495_p(posDown);
            if (stateDown.func_177230_c() != this) {
                worldIn.func_175698_g(pos);
            } else if (blockIn != this) {
                stateDown.func_189546_a(worldIn, posDown, blockIn, fromPos);
            }
        } else {
            boolean mustDrop = false;
            BlockPos posUp = pos.func_177984_a();
            IBlockState stateUp = worldIn.func_180495_p(posUp);
            if (stateUp.func_177230_c() != this) {
                worldIn.func_175698_g(pos);
                mustDrop = true;
            }
            if (!worldIn.func_180495_p(pos.func_177977_b()).isSideSolid((IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP)) {
                worldIn.func_175698_g(pos);
                mustDrop = true;
                if (stateUp.func_177230_c() == this) {
                    worldIn.func_175698_g(posUp);
                }
            }
            if (mustDrop) {
                if (!worldIn.field_72995_K) {
                    this.func_176226_b(worldIn, pos, state, 0);
                }
            } else {
                boolean isPowered;
                boolean bl = isPowered = worldIn.func_175640_z(pos) || worldIn.func_175640_z(posUp);
                if (blockIn != this && (isPowered || blockIn.func_176223_P().func_185897_m()) && isPowered != (Boolean)stateUp.func_177229_b((IProperty)POWERED)) {
                    worldIn.func_180501_a(posUp, stateUp.func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(isPowered)), 2);
                    if (isPowered != (Boolean)state.func_177229_b((IProperty)OPEN)) {
                        worldIn.func_180501_a(pos, state.func_177226_a((IProperty)OPEN, (Comparable)Boolean.valueOf(isPowered)), 2);
                        worldIn.func_175704_b(pos, pos);
                        worldIn.func_180498_a(null, isPowered ? this.getOpenSound() : this.getCloseSound(), pos, 0);
                    }
                }
            }
        }
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return state.func_177229_b(HALF) == EnumDoorHalf.UPPER ? Items.field_190931_a : this.getItem();
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        if (pos.func_177956_o() >= worldIn.func_72800_K() - 1) {
            return false;
        }
        return worldIn.func_180495_p(pos.func_177977_b()).func_193401_d((IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP) == BlockFaceShape.SOLID && super.func_176196_c(worldIn, pos) && super.func_176196_c(worldIn, pos.func_177984_a());
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.DESTROY;
    }

    private static int combineMetadata(IBlockAccess worldIn, BlockPos pos) {
        IBlockState state = worldIn.func_180495_p(pos);
        int i = state.func_177230_c().func_176201_c(state);
        boolean flag = BlockPaperDoor.isTop(i);
        IBlockState stateDown = worldIn.func_180495_p(pos.func_177977_b());
        int j = stateDown.func_177230_c().func_176201_c(stateDown);
        int k = flag ? j : i;
        IBlockState stateUp = worldIn.func_180495_p(pos.func_177984_a());
        int l = stateUp.func_177230_c().func_176201_c(stateUp);
        int i1 = flag ? i : l;
        boolean flag1 = (i1 & 1) != 0;
        boolean flag2 = (i1 & 2) != 0;
        return BlockPaperDoor.removeHalfBit(k) | (flag ? 8 : 0) | (flag1 ? 16 : 0) | (flag2 ? 32 : 0);
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack(this.getItem());
    }

    private Item getItem() {
        return DoTBItems.paper_door;
    }

    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        BlockPos posDown = pos.func_177977_b();
        BlockPos posUp = pos.func_177984_a();
        if (player.field_71075_bZ.field_75098_d && state.func_177229_b(HALF) == EnumDoorHalf.UPPER && worldIn.func_180495_p(posDown).func_177230_c() == this) {
            worldIn.func_175698_g(posDown);
        }
        if (state.func_177229_b(HALF) == EnumDoorHalf.LOWER && worldIn.func_180495_p(posUp).func_177230_c() == this) {
            if (player.field_71075_bZ.field_75098_d) {
                worldIn.func_175698_g(pos);
            }
            worldIn.func_175698_g(posUp);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        if (state.func_177229_b(HALF) == EnumDoorHalf.LOWER) {
            IBlockState stateUp = worldIn.func_180495_p(pos.func_177984_a());
            if (stateUp.func_177230_c() == this) {
                state = state.func_177226_a(HINGE, stateUp.func_177229_b(HINGE)).func_177226_a((IProperty)POWERED, stateUp.func_177229_b((IProperty)POWERED));
            }
        } else {
            IBlockState stateDown = worldIn.func_180495_p(pos.func_177977_b());
            if (stateDown.func_177230_c() == this) {
                state = state.func_177226_a((IProperty)FACING, stateDown.func_177229_b((IProperty)FACING)).func_177226_a((IProperty)OPEN, stateDown.func_177229_b((IProperty)OPEN));
            }
        }
        return state;
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177229_b(HALF) != EnumDoorHalf.LOWER ? state : state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return mirrorIn == Mirror.NONE ? state : state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING))).func_177231_a(HINGE);
    }

    public IBlockState func_176203_a(int meta) {
        return (meta & 8) > 0 ? this.func_176223_P().func_177226_a(HALF, (Comparable)((Object)EnumDoorHalf.UPPER)).func_177226_a(HINGE, (Comparable)((Object)((meta & 1) > 0 ? EnumHingePosition.RIGHT : EnumHingePosition.LEFT))).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf((meta & 2) > 0)) : this.func_176223_P().func_177226_a(HALF, (Comparable)((Object)EnumDoorHalf.LOWER)).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)(meta & 3)).func_176735_f()).func_177226_a((IProperty)OPEN, (Comparable)Boolean.valueOf((meta & 4) > 0));
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        if (state.func_177229_b(HALF) == EnumDoorHalf.UPPER) {
            i |= 8;
            if (state.func_177229_b(HINGE) == EnumHingePosition.RIGHT) {
                i |= 1;
            }
            if (((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue()) {
                i |= 2;
            }
        } else {
            i |= ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176746_e().func_176736_b();
            if (((Boolean)state.func_177229_b((IProperty)OPEN)).booleanValue()) {
                i |= 4;
            }
        }
        return i;
    }

    private static int removeHalfBit(int meta) {
        return meta & 7;
    }

    private static boolean isOpen(int combinedMeta) {
        return (combinedMeta & 4) != 0;
    }

    private static boolean isTop(int meta) {
        return (meta & 8) != 0;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{HALF, FACING, OPEN, HINGE, POWERED});
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing facing) {
        EnumFacing enumfacing = (EnumFacing)(state = this.func_176221_a(state, worldIn, pos)).func_177229_b((IProperty)FACING);
        return facing == enumfacing.func_176746_e() || facing == enumfacing.func_176735_f() ? BlockFaceShape.MIDDLE_POLE_THIN : BlockFaceShape.UNDEFINED;
    }

    @Override
    public Item getCustomItemBlock() {
        return ((Item)new ItemPaperDoor().setRegistryName(this.getRegistryName())).func_77655_b(this.func_149739_a());
    }

    public static enum EnumHingePosition implements IStringSerializable
    {
        LEFT,
        RIGHT;


        public String toString() {
            return this.func_176610_l();
        }

        public String func_176610_l() {
            return this == LEFT ? "left" : "right";
        }
    }

    public static enum EnumDoorHalf implements IStringSerializable
    {
        UPPER,
        LOWER;


        public String toString() {
            return this.func_176610_l();
        }

        public String func_176610_l() {
            return this == UPPER ? "upper" : "lower";
        }
    }
}

