/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftimebuilder.blocks.japanese;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.dawnoftimebuilder.DoTBUtils;
import org.dawnoftimebuilder.blocks.general.DoTBBlock;

public class BlockRedPaintedLog
extends DoTBBlock {
    private static final AxisAlignedBB AABB_AXIS_X = new AxisAlignedBB(0.1875, 0.0, 0.0, 0.8125, 0.625, 1.0);
    private static final AxisAlignedBB AABB_AXIS_Y = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 1.0, 0.75);
    private static final AxisAlignedBB AABB_AXIS_Z = new AxisAlignedBB(0.0, 0.0, 0.1875, 1.0, 0.625, 0.8125);
    private static final PropertyEnum<EnumFacing.Axis> MAIN_AXIS = PropertyEnum.func_177709_a((String)"main_axis", EnumFacing.Axis.class);
    private static final PropertyBool SUBAXIS_X = PropertyBool.func_177716_a((String)"subaxis_x");
    private static final PropertyBool SUBAXIS_Z = PropertyBool.func_177716_a((String)"subaxis_z");

    public BlockRedPaintedLog() {
        super("red_painted_log", Material.field_151575_d, 2.0f, SoundType.field_185848_a);
        this.setBurnable();
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(MAIN_AXIS, (Comparable)EnumFacing.Axis.Y).func_177226_a((IProperty)SUBAXIS_X, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)SUBAXIS_Z, (Comparable)Boolean.valueOf(false)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{MAIN_AXIS, SUBAXIS_X, SUBAXIS_Z});
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean p_185477_7_) {
        if (!p_185477_7_) {
            state = this.func_176221_a(state, (IBlockAccess)worldIn, pos);
        }
        for (AxisAlignedBB axisalignedbb : BlockRedPaintedLog.getCollisionBoxList(state)) {
            BlockRedPaintedLog.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)axisalignedbb);
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return DoTBUtils.getMainAABB(BlockRedPaintedLog.getCollisionBoxList(this.func_176221_a(state, source, pos)));
    }

    private static List<AxisAlignedBB> getCollisionBoxList(IBlockState state) {
        ArrayList list = Lists.newArrayList();
        switch ((EnumFacing.Axis)state.func_177229_b(MAIN_AXIS)) {
            case X: {
                list.add(AABB_AXIS_Z);
                break;
            }
            default: {
                list.add(AABB_AXIS_Y);
                break;
            }
            case Z: {
                list.add(AABB_AXIS_X);
            }
        }
        if (((Boolean)state.func_177229_b((IProperty)SUBAXIS_X)).booleanValue()) {
            list.add(AABB_AXIS_Z);
        }
        if (((Boolean)state.func_177229_b((IProperty)SUBAXIS_Z)).booleanValue()) {
            list.add(AABB_AXIS_X);
        }
        return list;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a(MAIN_AXIS, (Comparable)facing.func_176740_k());
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing side) {
        return side == EnumFacing.DOWN && state.func_177229_b(MAIN_AXIS) == EnumFacing.Axis.Y ? BlockFaceShape.CENTER_BIG : BlockFaceShape.UNDEFINED;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        boolean subaxisX = false;
        boolean subaxisZ = false;
        switch ((EnumFacing.Axis)state.func_177229_b(MAIN_AXIS)) {
            case X: {
                if (!this.isPaintedLog(worldIn, pos.func_177978_c()) && !this.isPaintedLog(worldIn, pos.func_177968_d())) break;
                subaxisZ = true;
                break;
            }
            case Z: {
                if (!this.isPaintedLog(worldIn, pos.func_177974_f()) && !this.isPaintedLog(worldIn, pos.func_177976_e())) break;
                subaxisX = true;
                break;
            }
            default: {
                if (this.isPaintedLog(worldIn, pos.func_177974_f()) || this.isPaintedLog(worldIn, pos.func_177976_e())) {
                    subaxisX = true;
                }
                if (!this.isPaintedLog(worldIn, pos.func_177978_c()) && !this.isPaintedLog(worldIn, pos.func_177968_d())) break;
                subaxisZ = true;
            }
        }
        return state.func_177226_a((IProperty)SUBAXIS_X, (Comparable)Boolean.valueOf(subaxisX)).func_177226_a((IProperty)SUBAXIS_Z, (Comparable)Boolean.valueOf(subaxisZ));
    }

    private boolean isPaintedLog(IBlockAccess world, BlockPos pos) {
        return world.func_180495_p(pos).func_177230_c() instanceof BlockRedPaintedLog;
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        EnumFacing.Axis axis = (EnumFacing.Axis)state.func_177229_b(MAIN_AXIS);
        if (axis == EnumFacing.Axis.X) {
            i |= 4;
        } else if (axis == EnumFacing.Axis.Z) {
            i |= 8;
        }
        return i;
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing.Axis axis = EnumFacing.Axis.Y;
        int i = meta & 0xC;
        if (i == 4) {
            axis = EnumFacing.Axis.X;
        } else if (i == 8) {
            axis = EnumFacing.Axis.Z;
        }
        return this.func_176223_P().func_177226_a(MAIN_AXIS, (Comparable)axis);
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }
}

