/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftimebuilder.blocks.japanese;

import java.util.Objects;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.dawnoftimebuilder.blocks.IBlockCustomItem;
import org.dawnoftimebuilder.blocks.general.DoTBBlock;
import org.dawnoftimebuilder.enums.EnumsBlock;
import org.dawnoftimebuilder.items.DoTBItems;
import org.dawnoftimebuilder.items.japanese.ItemStickBundle;

public class BlockStickBundle
extends DoTBBlock
implements IBlockCustomItem {
    private static final AxisAlignedBB AABB_TOP = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 1.0, 0.75);
    private static final AxisAlignedBB AABB_BOTTOM = new AxisAlignedBB(0.25, 0.25, 0.25, 0.75, 1.0, 0.75);
    public static final PropertyEnum<EnumsBlock.EnumHalf> HALF = PropertyEnum.func_177709_a((String)"half", EnumsBlock.EnumHalf.class);
    private static final PropertyInteger GROWTH = PropertyInteger.func_177719_a((String)"growth", (int)0, (int)3);

    public BlockStickBundle() {
        super("stick_bundle", Material.field_151575_d);
        this.setBurnable();
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)GROWTH, (Comparable)Integer.valueOf(0)).func_177226_a(HALF, (Comparable)((Object)EnumsBlock.EnumHalf.BOTTOM)));
        this.func_149675_a(true);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return state.func_177229_b(HALF) == EnumsBlock.EnumHalf.TOP ? AABB_TOP : AABB_BOTTOM;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{GROWTH, HALF});
    }

    public MapColor func_180659_g(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return MapColor.field_151650_B;
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        if (state.func_177229_b(HALF) == EnumsBlock.EnumHalf.TOP) {
            drops.add((Object)new ItemStack(DoTBItems.stick_bundle, 1));
        }
        switch ((Integer)state.func_177229_b((IProperty)GROWTH)) {
            case 4: {
                drops.add((Object)new ItemStack(DoTBItems.silk_cocoons, 1));
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                drops.add((Object)new ItemStack(DoTBItems.silk_worms, 1));
                break;
            }
        }
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack itemstack;
        if ((Integer)state.func_177229_b((IProperty)GROWTH) == 3) {
            BlockStickBundle.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)new ItemStack(DoTBItems.silk_cocoons, 1));
            worldIn.func_175656_a(pos, state.func_177226_a((IProperty)GROWTH, (Comparable)Integer.valueOf(0)));
            if (state.func_177229_b(HALF) == EnumsBlock.EnumHalf.TOP) {
                worldIn.func_175656_a(pos.func_177977_b(), this.func_176223_P().func_177226_a(HALF, (Comparable)((Object)EnumsBlock.EnumHalf.BOTTOM)).func_177226_a((IProperty)GROWTH, (Comparable)Integer.valueOf(0)));
            } else {
                worldIn.func_175656_a(pos.func_177984_a(), this.func_176223_P().func_177226_a(HALF, (Comparable)((Object)EnumsBlock.EnumHalf.TOP)).func_177226_a((IProperty)GROWTH, (Comparable)Integer.valueOf(0)));
            }
            return true;
        }
        if (!(worldIn.field_72995_K || worldIn.restoringBlockSnapshots || (Integer)state.func_177229_b((IProperty)GROWTH) != 0 || (itemstack = playerIn.func_184586_b(hand)).func_77973_b() != DoTBItems.silk_worms || itemstack.func_190926_b())) {
            itemstack.func_190918_g(1);
            worldIn.func_175656_a(pos, state.func_177226_a((IProperty)GROWTH, (Comparable)Integer.valueOf(1)));
            if (state.func_177229_b(HALF) == EnumsBlock.EnumHalf.TOP) {
                worldIn.func_175656_a(pos.func_177977_b(), this.func_176223_P().func_177226_a(HALF, (Comparable)((Object)EnumsBlock.EnumHalf.BOTTOM)).func_177226_a((IProperty)GROWTH, (Comparable)Integer.valueOf(1)));
            } else {
                worldIn.func_175656_a(pos.func_177984_a(), this.func_176223_P().func_177226_a(HALF, (Comparable)((Object)EnumsBlock.EnumHalf.TOP)).func_177226_a((IProperty)GROWTH, (Comparable)Integer.valueOf(1)));
            }
            return true;
        }
        return false;
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        int growth;
        if (state.func_177229_b(HALF) == EnumsBlock.EnumHalf.TOP && (growth = ((Integer)state.func_177229_b((IProperty)GROWTH)).intValue()) > 0 && growth < 3 && rand.nextInt(5) == 0) {
            worldIn.func_175656_a(pos, worldIn.func_180495_p(pos).func_177226_a((IProperty)GROWTH, (Comparable)Integer.valueOf(growth + 1)));
            worldIn.func_175656_a(pos.func_177977_b(), worldIn.func_180495_p(pos.func_177977_b()).func_177226_a((IProperty)GROWTH, (Comparable)Integer.valueOf(growth + 1)));
        }
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return super.func_176196_c(worldIn, pos) && super.func_176196_c(worldIn, pos.func_177977_b());
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (state.func_177229_b(HALF) == EnumsBlock.EnumHalf.TOP) {
            if (worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() != this) {
                this.func_176226_b(worldIn, pos, state, 0);
                worldIn.func_175698_g(pos);
            } else if (worldIn.func_180495_p(pos.func_177977_b()).func_177229_b(HALF) != EnumsBlock.EnumHalf.BOTTOM) {
                this.func_176226_b(worldIn, pos, state, 0);
                worldIn.func_175698_g(pos);
            }
        } else if (worldIn.func_180495_p(pos.func_177984_a()).func_177230_c() != this) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
        } else if (worldIn.func_180495_p(pos.func_177984_a()).func_177229_b(HALF) != EnumsBlock.EnumHalf.TOP) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
        }
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.DESTROY;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing facing) {
        return state.func_177229_b(HALF) == EnumsBlock.EnumHalf.TOP && facing == EnumFacing.UP ? BlockFaceShape.MIDDLE_POLE : BlockFaceShape.UNDEFINED;
    }

    public IBlockState func_176203_a(int meta) {
        IBlockState state = this.func_176223_P();
        if (meta > 3) {
            state = state.func_177226_a(HALF, (Comparable)((Object)EnumsBlock.EnumHalf.TOP));
            meta -= 4;
        }
        return state.func_177226_a((IProperty)GROWTH, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        int meta = state.func_177229_b(HALF) == EnumsBlock.EnumHalf.BOTTOM ? 0 : 4;
        return meta + (Integer)state.func_177229_b((IProperty)GROWTH);
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    @Override
    public Item getCustomItemBlock() {
        return ((Item)new ItemStickBundle().setRegistryName(Objects.requireNonNull(this.getRegistryName()))).func_77655_b(this.func_149739_a());
    }
}

