/*
 * Decompiled with CFR 0.152.
 */
package hohserg.elegant.networking.impl;

import hohserg.elegant.networking.api.ClientToServerPacket;
import hohserg.elegant.networking.api.ServerToClientPacket;
import hohserg.elegant.networking.impl.CCLNetworkImpl;
import hohserg.elegant.networking.impl.Config;
import hohserg.elegant.networking.impl.ForgeNetworkImpl;
import hohserg.elegant.networking.impl.Main;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.relauncher.Side;

public interface Network<PacketRepresentation> {
    public static final Network defaultImpl = Main.config.getBackgroundPacketSystem() == Config.BackgroundPacketSystem.CCLImpl ? (Loader.isModLoaded((String)"codechickenlib") ? new CCLNetworkImpl() : Network.throwMissingCCL()) : new ForgeNetworkImpl();

    public static Network throwMissingCCL() {
        throw new RuntimeException("Missed CodeChickenLib which required by elegant_networking.cfg");
    }

    public static Network getNetwork() {
        return defaultImpl;
    }

    public void sendToPlayer(ServerToClientPacket var1, EntityPlayerMP var2);

    public void sendToClients(ServerToClientPacket var1);

    public void sendPacketToAllAround(ServerToClientPacket var1, World var2, double var3, double var5, double var7, double var9);

    public void sendToDimension(ServerToClientPacket var1, World var2);

    public void sendToChunk(ServerToClientPacket var1, World var2, int var3, int var4);

    public void sendToServer(ClientToServerPacket var1);

    public void onReceiveClient(PacketRepresentation var1, String var2);

    public void onReceiveServer(PacketRepresentation var1, EntityPlayerMP var2, String var3);

    public void registerChannel(String var1);

    default public void checkSendingSide(ServerToClientPacket packet) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            throw new RuntimeException("Attempt to send ServerToClientPacket from client side: " + packet.getClass().getCanonicalName());
        }
    }

    default public void checkSendingSide(ClientToServerPacket packet) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            throw new RuntimeException("Attempt to send ClientToServerPacket from server side: " + packet.getClass().getCanonicalName());
        }
    }
}

