/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap;

import com.mamiyaotaru.voxelmap.ColorManager;
import com.mamiyaotaru.voxelmap.Map;
import com.mamiyaotaru.voxelmap.MapSettingsManager;
import com.mamiyaotaru.voxelmap.Radar;
import com.mamiyaotaru.voxelmap.RadarSettingsManager;
import com.mamiyaotaru.voxelmap.RadarSimple;
import com.mamiyaotaru.voxelmap.SettingsAndLightingChangeNotifier;
import com.mamiyaotaru.voxelmap.WaypointManager;
import com.mamiyaotaru.voxelmap.forgemod.ForgeModVoxelMap;
import com.mamiyaotaru.voxelmap.forgemod.WorldIDPacket;
import com.mamiyaotaru.voxelmap.interfaces.AbstractVoxelMap;
import com.mamiyaotaru.voxelmap.interfaces.IColorManager;
import com.mamiyaotaru.voxelmap.interfaces.IDimensionManager;
import com.mamiyaotaru.voxelmap.interfaces.IMap;
import com.mamiyaotaru.voxelmap.interfaces.IPersistentMap;
import com.mamiyaotaru.voxelmap.interfaces.IRadar;
import com.mamiyaotaru.voxelmap.interfaces.ISettingsAndLightingChangeNotifier;
import com.mamiyaotaru.voxelmap.interfaces.IWaypointManager;
import com.mamiyaotaru.voxelmap.persistent.PersistentMap;
import com.mamiyaotaru.voxelmap.persistent.PersistentMapSettingsManager;
import com.mamiyaotaru.voxelmap.util.BiomeRepository;
import com.mamiyaotaru.voxelmap.util.DimensionManager;
import com.mamiyaotaru.voxelmap.util.GLUtils;
import com.mamiyaotaru.voxelmap.util.GameVariableAccessShim;
import com.mamiyaotaru.voxelmap.util.WorldUpdateListener;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.world.IWorldEventListener;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class VoxelMap
extends AbstractVoxelMap
implements IResourceManagerReloadListener {
    private MapSettingsManager mapOptions = null;
    private RadarSettingsManager radarOptions = null;
    private PersistentMapSettingsManager persistentMapOptions = null;
    private IMap map = null;
    private IRadar radar = null;
    private IRadar radarSimple = null;
    private PersistentMap persistentMap = null;
    private ISettingsAndLightingChangeNotifier settingsAndLightingChangeNotifier = null;
    private WorldUpdateListener worldUpdateListener = null;
    private IColorManager colorManager = null;
    private IWaypointManager waypointManager = null;
    private IDimensionManager dimensionManager = null;
    private World world;

    public VoxelMap() {
        instance = this;
    }

    public void lateInit(boolean showUnderMenus, boolean isFair) {
        GLUtils.textureManager = Minecraft.func_71410_x().func_110434_K();
        this.mapOptions = new MapSettingsManager();
        this.mapOptions.showUnderMenus = showUnderMenus;
        this.radarOptions = new RadarSettingsManager();
        this.mapOptions.addSecondaryOptionsManager(this.radarOptions);
        this.persistentMapOptions = new PersistentMapSettingsManager();
        this.mapOptions.addSecondaryOptionsManager(this.persistentMapOptions);
        BiomeRepository.loadBiomeColors();
        this.colorManager = new ColorManager(this);
        this.waypointManager = new WaypointManager(this);
        this.dimensionManager = new DimensionManager(this);
        this.persistentMap = new PersistentMap(this);
        this.mapOptions.loadAll();
        try {
            if (isFair) {
                this.radarOptions.radarAllowed = false;
                this.radarOptions.radarMobsAllowed = false;
                this.radarOptions.radarPlayersAllowed = false;
            } else {
                this.radarOptions.radarAllowed = true;
                this.radarOptions.radarMobsAllowed = true;
                this.radarOptions.radarPlayersAllowed = true;
                this.radar = new Radar(this);
                this.radarSimple = new RadarSimple(this);
            }
        }
        catch (Exception e) {
            this.radarOptions.radarAllowed = false;
            this.radarOptions.radarMobsAllowed = false;
            this.radarOptions.radarPlayersAllowed = false;
            this.radar = null;
            this.radarSimple = null;
        }
        this.map = new Map(this);
        this.settingsAndLightingChangeNotifier = new SettingsAndLightingChangeNotifier();
        this.worldUpdateListener = new WorldUpdateListener();
        this.worldUpdateListener.addListener(this.map);
        this.worldUpdateListener.addListener(this.persistentMap);
        IReloadableResourceManager resourceManager = (IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L();
        resourceManager.func_110542_a((IResourceManagerReloadListener)this);
    }

    public void func_110549_a(IResourceManager resourceManager) {
        this.waypointManager.onResourceManagerReload(resourceManager);
        if (this.radar != null) {
            this.radar.onResourceManagerReload(resourceManager);
        }
        if (this.radarSimple != null) {
            this.radarSimple.onResourceManagerReload(resourceManager);
        }
        this.colorManager.onResourceManagerReload(resourceManager);
    }

    public void onTickInGame(Minecraft mc) {
        this.map.onTickInGame(mc);
    }

    public void onSetupCameraTransform() {
        this.map.getFogColor();
    }

    public void onTick(Minecraft mc, boolean clock) {
        if (GameVariableAccessShim.getWorld() != null && !GameVariableAccessShim.getWorld().equals(this.world) || this.world != null && !this.world.equals(GameVariableAccessShim.getWorld())) {
            if (this.world != null) {
                this.world.func_72848_b((IWorldEventListener)this.worldUpdateListener);
            }
            this.world = GameVariableAccessShim.getWorld();
            if (this.world != null) {
                this.newSubWorldName("", false);
                ForgeModVoxelMap.WORLD_ID.sendToServer((IMessage)new WorldIDPacket());
                mc.field_71439_g.func_110306_p();
                java.util.Map skinMap = mc.func_152342_ad().func_152788_a(mc.field_71439_g.func_146103_bH());
                if (skinMap.containsKey(MinecraftProfileTexture.Type.SKIN)) {
                    mc.func_152342_ad().func_152792_a((MinecraftProfileTexture)skinMap.get(MinecraftProfileTexture.Type.SKIN), MinecraftProfileTexture.Type.SKIN);
                }
                this.map.newWorld(this.world);
                this.world.func_72954_a((IWorldEventListener)this.worldUpdateListener);
            }
            this.waypointManager.newWorld(this.world);
            this.persistentMap.newWorld(this.world);
        }
        this.map.onTick(mc, clock);
        this.persistentMap.onTick(mc);
    }

    public void setConnectedRealm(String id) {
        this.waypointManager.setConnectedRealm(id);
    }

    @Override
    public MapSettingsManager getMapOptions() {
        return this.mapOptions;
    }

    @Override
    public RadarSettingsManager getRadarOptions() {
        return this.radarOptions;
    }

    @Override
    public PersistentMapSettingsManager getPersistentMapOptions() {
        return this.persistentMapOptions;
    }

    @Override
    public IMap getMap() {
        return this.map;
    }

    @Override
    public ISettingsAndLightingChangeNotifier getSettingsAndLightingChangeNotifier() {
        return this.settingsAndLightingChangeNotifier;
    }

    @Override
    public IRadar getRadar() {
        if (this.radarOptions.showRadar) {
            if (this.radarOptions.radarMode == this.radarOptions.SIMPLE) {
                return this.radarSimple;
            }
            if (this.radarOptions.radarMode == this.radarOptions.FULL) {
                return this.radar;
            }
        }
        return null;
    }

    @Override
    public IColorManager getColorManager() {
        return this.colorManager;
    }

    @Override
    public IWaypointManager getWaypointManager() {
        return this.waypointManager;
    }

    @Override
    public IDimensionManager getDimensionManager() {
        return this.dimensionManager;
    }

    @Override
    public IPersistentMap getPersistentMap() {
        return this.persistentMap;
    }

    @Override
    public void setPermissions(boolean hasFullRadarPermission, boolean hasPlayersOnRadarPermission, boolean hasMobsOnRadarPermission, boolean hasCavemodePermission) {
        boolean override = false;
        try {
            UUID devUUID = UUID.fromString("9b37abb9-2487-4712-bb96-21a1e0b2023c");
            UUID playerUUID = Minecraft.func_71410_x().field_71439_g.func_110124_au();
            override = playerUUID.equals(devUUID);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.radarOptions.radarAllowed = hasFullRadarPermission || override;
        this.radarOptions.radarPlayersAllowed = hasPlayersOnRadarPermission || override;
        this.radarOptions.radarMobsAllowed = hasMobsOnRadarPermission || override;
        this.mapOptions.cavesAllowed = hasCavemodePermission || override;
    }

    @Override
    public synchronized void newSubWorldName(String name, boolean fromServer) {
        this.waypointManager.setSubworldName(name, fromServer);
    }

    @Override
    public synchronized void newSubWorldHash(String hash) {
        this.waypointManager.setSubworldHash(hash);
    }

    @Override
    public String getWorldSeed() {
        if (Minecraft.func_71410_x().func_71387_A()) {
            return Long.toString(Minecraft.func_71410_x().func_71401_C().func_130014_f_().func_72905_C());
        }
        return this.waypointManager.getWorldSeed();
    }

    @Override
    public void setWorldSeed(String newSeed) {
        if (!Minecraft.func_71410_x().func_71387_A()) {
            this.waypointManager.setWorldSeed(newSeed);
        }
    }
}

