package net.decentstudio.spawners.network.packets;

import hohserg.elegant.networking.impl.ISerializer;
import hohserg.elegant.networking.impl.SerializerMark;
import io.netty.buffer.ByteBuf;

@SerializerMark(
    packetClass = net.decentstudio.spawners.network.packets.C0OpenSpawnGui.class
)
public class C0OpenSpawnGuiSerializer implements ISerializer<C0OpenSpawnGui> {
  public void serialize(C0OpenSpawnGui value, ByteBuf acc) {
    serialize_C0OpenSpawnGui_Generic(value, acc);
  }

  public C0OpenSpawnGui unserialize(ByteBuf buf) {
    return unserialize_C0OpenSpawnGui_Generic(buf);
  }

  void serialize_C0OpenSpawnGui_Generic(C0OpenSpawnGui value, ByteBuf acc) {
    serialize_C0OpenSpawnGui_Concretic(value, acc);
  }

  C0OpenSpawnGui unserialize_C0OpenSpawnGui_Generic(ByteBuf buf) {
    return unserialize_C0OpenSpawnGui_Concretic(buf);
  }

  void serialize_C0OpenSpawnGui_Concretic(C0OpenSpawnGui value, ByteBuf acc) {
    serialize_BlockPos_Generic(value.pos, acc);
    serialize_NBTTagCompound_Generic(value.tagCompound, acc);
  }

  C0OpenSpawnGui unserialize_C0OpenSpawnGui_Concretic(ByteBuf buf) {
    C0OpenSpawnGui value = new C0OpenSpawnGui(unserialize_BlockPos_Generic(buf), unserialize_NBTTagCompound_Generic(buf));
    return value;
  }
}
